/*
 * Decompiled with CFR 0.152.
 */
package com.itayfeder.nock_enough_arrows.events;

import com.itayfeder.nock_enough_arrows.NockEnoughArrowsConfig;
import com.itayfeder.nock_enough_arrows.init.EntityTypeInit;
import com.itayfeder.nock_enough_arrows.sputter.Sputter;
import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="nock_enough_arrows", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class GolemCreatureEvents {
    private static BlockPattern sputterBase;
    private static BlockPattern sputterFull;
    private static final Predicate<BlockState> PUMPKINS_PREDICATE;
    private static final Predicate<BlockState> PLANKS_PREDICATE;

    @SubscribeEvent
    public static void arrowReleaseHandler(BlockEvent.EntityPlaceEvent event) {
        LevelAccessor levelAccessor;
        if (((Boolean)NockEnoughArrowsConfig.COMMON.enableSputter.get()).booleanValue() && (levelAccessor = event.getLevel()) instanceof Level) {
            Level level = (Level)levelAccessor;
            GolemCreatureEvents.trySpawnGolem(level, event.getPos());
        }
    }

    private static void trySpawnGolem(Level p_51379_, BlockPos p_51380_) {
        BlockPattern.BlockPatternMatch blockpattern$blockpatternmatch = GolemCreatureEvents.getOrCreateSputterFull().m_61184_((LevelReader)p_51379_, p_51380_);
        if (blockpattern$blockpatternmatch != null) {
            for (int i = 0; i < GolemCreatureEvents.getOrCreateSputterFull().m_61202_(); ++i) {
                BlockInWorld blockinworld = blockpattern$blockpatternmatch.m_61229_(0, i, 0);
                p_51379_.m_7731_(blockinworld.m_61176_(), Blocks.f_50016_.m_49966_(), 2);
                p_51379_.m_46796_(2001, blockinworld.m_61176_(), Block.m_49956_((BlockState)blockinworld.m_61168_()));
            }
            Sputter snowgolem = (Sputter)((EntityType)EntityTypeInit.SPUTTER.get()).m_20615_(p_51379_);
            BlockPos blockpos1 = blockpattern$blockpatternmatch.m_61229_(0, 1, 0).m_61176_();
            snowgolem.m_7678_((double)blockpos1.m_123341_() + 0.5, (double)blockpos1.m_123342_() + 0.05, (double)blockpos1.m_123343_() + 0.5, 0.0f, 0.0f);
            p_51379_.m_7967_((Entity)snowgolem);
            for (ServerPlayer serverplayer : p_51379_.m_45976_(ServerPlayer.class, snowgolem.m_20191_().m_82400_(5.0))) {
                CriteriaTriggers.f_10580_.m_68256_(serverplayer, (Entity)snowgolem);
            }
            for (int l = 0; l < GolemCreatureEvents.getOrCreateSputterFull().m_61202_(); ++l) {
                BlockInWorld blockinworld3 = blockpattern$blockpatternmatch.m_61229_(0, l, 0);
                p_51379_.m_6289_(blockinworld3.m_61176_(), Blocks.f_50016_);
            }
        }
    }

    private static BlockPattern getOrCreateSputterBase() {
        if (sputterBase == null) {
            sputterBase = BlockPatternBuilder.m_61243_().m_61247_(new String[]{" ", "#"}).m_61244_('#', BlockInWorld.m_61169_(PLANKS_PREDICATE)).m_61249_();
        }
        return sputterBase;
    }

    private static BlockPattern getOrCreateSputterFull() {
        if (sputterFull == null) {
            sputterFull = BlockPatternBuilder.m_61243_().m_61247_(new String[]{"^", "#"}).m_61244_('^', BlockInWorld.m_61169_(PUMPKINS_PREDICATE)).m_61244_('#', BlockInWorld.m_61169_(PLANKS_PREDICATE)).m_61249_();
        }
        return sputterFull;
    }

    static {
        PUMPKINS_PREDICATE = p_51396_ -> p_51396_ != null && (p_51396_.m_60713_(Blocks.f_50143_) || p_51396_.m_60713_(Blocks.f_50144_));
        PLANKS_PREDICATE = p_51396_ -> p_51396_ != null && p_51396_.m_204336_(Tags.Blocks.BARRELS);
    }
}

